import FullCalendar from '@fullcalendar/react';
import dayGridPlugin from '@fullcalendar/daygrid';
import interactionPlugin from '@fullcalendar/interaction';
import timeGridPlugin from '@fullcalendar/timegrid';
import * as React from 'react';
import { set, kebabCase } from 'lodash';
import { convertDeepBindToPathNotNull } from '../../../utils/nested-field-utils';
import { datePropertyValueToDateString } from '@sage/xtrem-date-time';
import { CalendarEventCardComponent } from './calendar-event-component';
import { triggerFieldEvent } from '../../../utils/events';
import esLocale from '@fullcalendar/core/locales/es';
import enGbLocale from '@fullcalendar/core/locales/en-gb';
import frLocale from '@fullcalendar/core/locales/fr';
import zhCnLocale from '@fullcalendar/core/locales/zh-cn';
import deLocale from '@fullcalendar/core/locales/de';
import plLocale from '@fullcalendar/core/locales/pl';
import ptLocale from '@fullcalendar/core/locales/pt';
import arSaLocale from '@fullcalendar/core/locales/ar-sa';
import { useSelector } from 'react-redux';
import { eventFormatter, getCalendarLocale } from './calendar-body-utils';
const headerItems = ['back', 'today', 'prev', 'next', 'title'];
export const CalendarComponentBody = React.memo(({ cardColor, elementId, endDateField, eventCard, fieldProperties, fixedHeight, onEventClick, hasClickEventListener, isGreaterThanSmall, maxDate, minDate, screenId, selectedOptionsMenuItem, selectedView: externalSelectedView, startDateField, value, isEventMovable, }) => {
    const [selectedView, setSelectedView] = React.useState(externalSelectedView || 'dayGridMonth');
    const calendarApiRef = React.useRef();
    const userLocale = useSelector(state => state.applicationContext?.locale) || 'en-US';
    const isMobileMonthlyView = React.useCallback(() => !isGreaterThanSmall && selectedView === 'dayGridMonth', [isGreaterThanSmall, selectedView]);
    const openInDayView = React.useCallback((date) => {
        setSelectedView('dayGridDay');
        calendarApiRef.current?.gotoDate(date);
    }, []);
    const triggerOnEventClick = React.useCallback(({ event, jsEvent }) => {
        jsEvent.stopPropagation();
        jsEvent.preventDefault();
        if (isMobileMonthlyView() && event.start) {
            openInDayView(event.start);
        }
        else if (value) {
            // TS 5.2 added any cast
            const _id = event._def.extendedProps._id;
            const eventValue = value.getRecordByIdAndLevel({ id: _id });
            const isModifierKeyPushed = jsEvent.ctrlKey || jsEvent.metaKey;
            if (onEventClick) {
                onEventClick(_id, eventValue, isModifierKeyPushed);
            }
            else {
                triggerFieldEvent(screenId, elementId, 'onEventClick', _id, eventValue, isModifierKeyPushed);
            }
        }
    }, [elementId, isMobileMonthlyView, onEventClick, openInDayView, screenId, value]);
    const triggerOnDateClick = React.useCallback(({ date, jsEvent }) => {
        jsEvent.stopPropagation();
        jsEvent.preventDefault();
        if (isMobileMonthlyView()) {
            openInDayView(date);
        }
        else {
            triggerFieldEvent(screenId, elementId, 'onDayClick', date);
        }
    }, [elementId, isMobileMonthlyView, openInDayView, screenId]);
    const fetchEvents = React.useCallback(async (info, successCb) => {
        if (value) {
            let filter = {};
            const startDateFilter = set({}, convertDeepBindToPathNotNull(startDateField), {
                _gte: info.startStr,
                _lte: info.endStr,
            });
            if (endDateField) {
                const endDateFilter = set({}, convertDeepBindToPathNotNull(endDateField), {
                    _gte: info.startStr,
                    _lte: info.endStr,
                });
                const eventLongerThanViewSpanFilter = {
                    _and: [
                        set({}, convertDeepBindToPathNotNull(endDateField), { _gte: info.startStr }),
                        set({}, convertDeepBindToPathNotNull(startDateField), { _gte: info.endStr }),
                    ],
                };
                filter = {
                    _or: [startDateFilter, endDateFilter, eventLongerThanViewSpanFilter],
                };
            }
            else {
                filter = startDateFilter;
            }
            const events = await value.getPage({
                tableFieldProperties: fieldProperties,
                pageSize: 500,
                rawFilter: filter,
                orderBy: set({}, convertDeepBindToPathNotNull(startDateField), 1),
                selectedOptionsMenuItem,
            });
            successCb(events.map(record => eventFormatter({
                endDateField,
                isEventMovable,
                record,
                screenId,
                startDateField,
            })));
        }
        return [];
    }, [endDateField, fieldProperties, isEventMovable, screenId, selectedOptionsMenuItem, startDateField, value]);
    React.useEffect(() => {
        calendarApiRef.current?.changeView(selectedView);
    }, [selectedView]);
    React.useEffect(() => {
        if (externalSelectedView) {
            setSelectedView(externalSelectedView);
        }
    }, [externalSelectedView]);
    React.useEffect(() => {
        calendarApiRef.current?.refetchEvents();
    }, [value, calendarApiRef, selectedOptionsMenuItem]);
    const eventContent = React.useCallback((eventProps) => (React.createElement(CalendarEventCardComponent, { elementId: elementId, eventProps: eventProps, value: value, screenId: screenId, isMobileMonthlyView: isMobileMonthlyView(), cardColor: cardColor, hasClickEventListener: hasClickEventListener, selectedView: selectedView, eventCard: eventCard })), [
        cardColor,
        elementId,
        eventCard,
        hasClickEventListener,
        isMobileMonthlyView,
        screenId,
        selectedView,
        value,
    ]);
    const end = React.useMemo(() => datePropertyValueToDateString(minDate) || undefined, [minDate]);
    const start = React.useMemo(() => datePropertyValueToDateString(maxDate) || undefined, [maxDate]);
    const onCustomButtonsClick = React.useCallback(() => {
        setSelectedView('dayGridMonth');
    }, []);
    const calendarProps = React.useMemo(() => ({
        headerToolbar: {
            left: headerItems.join(' '),
            center: '',
            right: '',
        },
        locales: [esLocale, enGbLocale, plLocale, deLocale, ptLocale, frLocale, zhCnLocale, arSaLocale],
        locale: getCalendarLocale(userLocale),
        weekends: true,
        initialView: 'dayGridMonth',
        views: {
            dayGridMonth: {
                dayMaxEvents: 4, // Three events + text show more = 4
                moreLinkClick: 'dayGridThree',
            },
            dayGridThree: {
                type: 'dayGrid',
                duration: { days: 3 },
                buttonText: '3 day',
                eventLimit: false,
            },
        },
        customButtons: {
            back: {
                text: 'back',
                click: onCustomButtonsClick,
            },
        },
        editable: !!isEventMovable,
        plugins: [dayGridPlugin, timeGridPlugin, interactionPlugin],
        events: fetchEvents,
        fixedWeekCount: false,
        eventContent,
        eventClick: triggerOnEventClick,
        dateClick: triggerOnDateClick,
        height: fixedHeight,
        validRange: {
            start,
            end,
        },
    }), [
        end,
        eventContent,
        fetchEvents,
        fixedHeight,
        isEventMovable,
        onCustomButtonsClick,
        start,
        triggerOnDateClick,
        triggerOnEventClick,
        userLocale,
    ]);
    return (React.createElement("div", { className: `e-calendar-body e-calendar-body-type-${kebabCase(String(selectedView))}` },
        React.createElement(FullCalendar, { ref: (c) => {
                calendarApiRef.current = c?.getApi();
            }, ...calendarProps })));
});
CalendarComponentBody.displayName = 'CalendarComponentBody';
//# sourceMappingURL=calendar-body-component.js.map