import { connect } from 'react-redux';
import { getSidebarLayoutDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import { ConnectedTableSidebarBlock } from './table-sidebar-block';
import { resolveByValue } from '../../utils/resolve-value-utils';
export function TableSidebarSection({ blocks, section }) {
    return (React.createElement("div", { className: "e-table-sidebar-section" }, blocks.map(block => (React.createElement(ConnectedTableSidebarBlock, { key: block, section: section, block: block })))));
}
export const mapStateToProps = (state, props) => {
    const sidebarLayoutDefinition = getSidebarLayoutDefinitionFromState(state);
    let recordValue = {};
    if (state.sidebar?.screenId && state.sidebar?.elementId && state.sidebar?.recordId) {
        const screenDefinition = state.screenDefinitions[state.sidebar.screenId];
        const value = screenDefinition.values[state.sidebar.elementId];
        recordValue = value.getRawRecord({
            id: state.sidebar.recordId,
            cleanMetadata: true,
            isUncommitted: true,
            level: state.sidebar.level,
        });
    }
    const blocks = sidebarLayoutDefinition[props.section]
        ? Object.keys(sidebarLayoutDefinition[props.section].blocks)
        : [];
    return {
        ...props,
        blocks: blocks.filter(b => {
            const blockDefinition = sidebarLayoutDefinition[props.section].blocks[b];
            const isHidden = (!!state.sidebar?.screenId &&
                resolveByValue({
                    propertyValue: blockDefinition.isHidden,
                    rowValue: recordValue,
                    fieldValue: recordValue?._id,
                    screenId: state.sidebar.screenId,
                    skipHexFormat: true,
                })) ||
                false;
            return !isHidden;
        }),
    };
};
export const ConnectedTableSidebarSection = connect(mapStateToProps)(TableSidebarSection);
//# sourceMappingURL=table-sidebar-section.js.map