import * as React from 'react';
import type * as xtremRedux from '../../redux';
import type { OnTelemetryEventFunction } from '../../redux/state';
import type { CollectionValue } from '../../service/collection-data-service';
import type { AccessBindings } from '../../service/page-definition';
import type { ScreenBaseDefinition } from '../../service/screen-base-definition';
import type { MenuSeparatorType } from '../container/page/page-types';
import type { ErrorHandlerFunction } from '../field/traits';
import type { CollectionItemAction, CollectionItemActionGroup } from '../ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
export interface TableSidebarHeaderProps {
    accessBindings: AccessBindings;
    elementId: string;
    hasNextRecord: boolean;
    hasPreviousRecord: boolean;
    headerDropdownActions?: Array<CollectionItemAction<any> | CollectionItemActionGroup<any> | MenuSeparatorType>;
    headerQuickActions?: Array<CollectionItemAction<any>>;
    isLoading: boolean;
    isUncommitted: boolean;
    level?: number;
    onError?: ErrorHandlerFunction<any>;
    onNextRecord: () => Promise<void>;
    onPreviousRecord: () => Promise<void>;
    onTelemetryEvent?: OnTelemetryEventFunction;
    recordId?: string;
    recordValue: any;
    screenDefinition: ScreenBaseDefinition;
    screenId: string;
    sidebarGetTitle?: string | ((_id: string, recordValue?: any) => string);
    tableTitle?: string;
    value?: CollectionValue;
}
export declare function TableSidebarHeader({ accessBindings, elementId, hasNextRecord, hasPreviousRecord, headerDropdownActions, headerQuickActions, isLoading, onError, onNextRecord, onPreviousRecord: onPrevRecord, onTelemetryEvent, recordValue, screenDefinition, screenId, sidebarGetTitle, tableTitle, }: TableSidebarHeaderProps): React.ReactElement | null;
export declare const mapDispatchToProps: (dispatch: xtremRedux.AppThunkDispatch) => Partial<TableSidebarHeaderProps>;
export declare const mapStateToProps: (state: xtremRedux.XtremAppState) => Partial<TableSidebarHeaderProps>;
export declare const ConnectedTableSidebarHeader: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarHeaderProps>, {
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<TableSidebarHeaderProps, any, any>> | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=table-sidebar-header.d.ts.map