import React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../redux';
import { localize } from '../../service/i18n-service';
import { withCollectionValueItemSubscription } from '../connected-collection';
import Button from 'carbon-react/esm/components/button';
import { getPageDefinitionFromState, getSidebarNormalFields } from '../../utils/state-utils';
import styled from 'styled-components';
export function TableSidebarFooter({ validationErrors, isNewRecord, onConfirm, onCancel, externalErrors, browser, }) {
    const StyledApplyNewButton = browser && browser.lessThan.m
        ? styled(Button) `
                  padding: 0 11px;
                  margin-left: 0px;
              `
        : Button;
    const applyAndAddNew = browser && browser.lessThan.m
        ? localize('@sage/xtrem-ui/sidebar-mobile-apply-changes-and-create-new', 'Apply & new')
        : localize('@sage/xtrem-ui/sidebar-apply-changes-and-create-new', 'Apply and add new');
    const StyledCancel = browser && browser.lessThan.m
        ? styled(Button) `
                  margin-left: 0px;
                  padding-left: 0px;
              `
        : Button;
    return (React.createElement("div", { className: "e-table-sidebar-footer" },
        React.createElement(StyledCancel, { "data-testid": "e-table-sidebar-cancel-button", buttonType: "tertiary", onClick: onCancel, ml: "24px" }, localize('@sage/xtrem-ui/cancel', 'Cancel')),
        isNewRecord && (React.createElement(StyledApplyNewButton, { "data-testid": "e-table-sidebar-confirm-and-add-new-button", buttonType: "secondary", onClick: () => onConfirm(true), ml: "24px", disabled: validationErrors.length > 0 || externalErrors }, applyAndAddNew)),
        React.createElement(Button, { "data-testid": "e-table-sidebar-confirm-button", buttonType: "primary", onClick: () => onConfirm(false), ml: "24px", disabled: validationErrors.length > 0 || externalErrors }, localize('@sage/xtrem-ui/sidebar-apply-changes', 'Apply'))));
}
const mapStateToProps = (state) => {
    let screenDefinition;
    let value;
    let externalErrors = false;
    if (state.sidebar?.screenId) {
        screenDefinition = getPageDefinitionFromState(state.sidebar.screenId, state);
        value = screenDefinition.values[state.sidebar.elementId];
        const validationErrors = Object.keys(screenDefinition.errors).filter(e => screenDefinition.errors[e].length > 0);
        if (validationErrors.length > 0) {
            const fields = getSidebarNormalFields(state).map(field => field.id);
            externalErrors = Boolean(validationErrors.find(field => fields.includes(field)));
        }
    }
    return {
        isNewRecord: state.sidebar?.isNewRecord,
        recordId: state.sidebar?.recordId || undefined,
        value,
        isUncommitted: true,
        externalErrors,
        level: state.sidebar?.level,
        browser: state.browser,
    };
};
export const mapDispatchToProps = (dispatch) => {
    return {
        onConfirm: (addNewRecord = false) => {
            dispatch(xtremRedux.actions.confirmTableSidebar(addNewRecord));
        },
        onCancel: () => {
            dispatch(xtremRedux.actions.closeTableSidebar());
        },
    };
};
export const ConnectedTableSidebarFooter = connect(mapStateToProps, mapDispatchToProps)(withCollectionValueItemSubscription(TableSidebarFooter));
//# sourceMappingURL=table-sidebar-footer.js.map