import { connect } from 'react-redux';
import { getSidebarLayoutDefinitionFromState } from '../../utils/state-utils';
import { XtremTabs } from '../ui/tabs/xtrem-tabs';
import React from 'react';
import { ConnectedTableSidebarSection } from './table-sidebar-section';
import { ConnectedTableSidebarCard } from './table-sidebar-card';
import { resolveByValue } from '../../utils/resolve-value-utils';
import { withCollectionValueItemSubscription } from '../connected-collection';
export function TableSidebarBody({ validationErrors, sidebarLayoutDefinition, screenId, recordId, recordValue, }) {
    const sections = React.useMemo(() => Object.keys(sidebarLayoutDefinition).reduce((acc, currentKey) => {
        const sectionDefinition = sidebarLayoutDefinition[currentKey];
        const isHidden = (!!screenId &&
            resolveByValue({
                propertyValue: sectionDefinition.isHidden,
                rowValue: recordValue,
                fieldValue: recordId,
                screenId,
                skipHexFormat: true,
            })) ||
            false;
        if (isHidden) {
            return acc;
        }
        let errorMessage;
        Object.keys(sectionDefinition.blocks).some(blockKey => {
            const fields = sectionDefinition.blocks[blockKey].fields;
            // Find if inside validation errors columnId match with some of the fields array and return that validationError
            const validationError = validationErrors.find(error => fields && fields.includes(error.columnId));
            if (validationError?.message) {
                errorMessage = validationError?.message;
                return true;
            }
            return false;
        });
        acc.push({ id: currentKey, title: sectionDefinition.title, validationMessage: errorMessage });
        return acc;
    }, []), [recordId, recordValue, screenId, sidebarLayoutDefinition, validationErrors]);
    const [currentTab, setCurrentTab] = React.useState(sections[0]?.id || '');
    return (React.createElement("div", { className: "e-table-sidebar-body" },
        screenId && React.createElement(ConnectedTableSidebarCard, null),
        React.createElement(XtremTabs, { tabs: sections, selectedTabId: currentTab, onTabChange: setCurrentTab, inSidebar: true }),
        currentTab && screenId && React.createElement(ConnectedTableSidebarSection, { section: currentTab })));
}
export const mapStateToProps = (state) => {
    const sidebarLayoutDefinition = getSidebarLayoutDefinitionFromState(state);
    let value;
    if (state.sidebar?.screenId) {
        const screenDefinition = state.screenDefinitions[state.sidebar.screenId];
        value = screenDefinition.values[state.sidebar.elementId];
    }
    return {
        sidebarLayoutDefinition,
        value,
        recordId: state.sidebar?.recordId || undefined,
        screenId: state.sidebar?.screenId,
        isUncommitted: true,
        level: state.sidebar?.level,
    };
};
export const ConnectedTableSidebarBody = connect(mapStateToProps)(withCollectionValueItemSubscription(TableSidebarBody));
//# sourceMappingURL=table-sidebar-body.js.map