/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../service/screen-base';
import type { UiComponentProperties } from './abstract-ui-control-object';
import { AbstractUiControlObject } from './abstract-ui-control-object';
import type { PropertyValueType } from './field/reference/reference-types';
import type { FieldControlObjectConstructorProps, FieldInternalValue, FieldKey, FieldValue, FieldWidth } from './types';
export interface ReadonlyFieldProperties<CT extends ScreenBase = ScreenBase> extends UiComponentProperties<CT> {
    /** The GraphQL node that the field’s value is bound to. If not provided, the field name is used instead */
    bind?: PropertyValueType<ScreenBase extends ScreenBase<infer _A, infer U> ? U : ClientNode>;
    /** A text that will be displayed below the field */
    helperText?: string;
    /** Whether the field spans all the parent width or not. Defaults to false */
    isFullWidth?: boolean;
    /** The width of the block relative to the section where it is place.
     * Must be a number between 1 and 12, both included */
    width?: FieldWidth;
    /** Whether the field helper text is hidden or not. Defaults to false */
    isHelperTextHidden?: boolean;
    /** Whether the value is bound only to GraphQL mutations (isTransientInput = true) or not (isTransientInput = false). Defaults to false */
    isTransientInput?: boolean;
}
/**
 * Any element holding a value than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting field's ui properties values). The element value CANNOT be modified
 */
export declare abstract class ReadonlyFieldControlObject<CT extends ScreenBase, T extends FieldKey, S extends ReadonlyFieldProperties<CT>, N extends ClientNode = any> extends AbstractUiControlObject<CT, S> {
    layout: FieldControlObjectConstructorProps<T>['layout'];
    parent?: FieldControlObjectConstructorProps<T>['parent'];
    insertBefore?: FieldControlObjectConstructorProps<T>['insertBefore'];
    insertAfter?: FieldControlObjectConstructorProps<T>['insertAfter'];
    protected readonly _getValue: () => FieldInternalValue<T, N> | null;
    protected readonly _setValue: (newValue: FieldInternalValue<T, N> | null) => void;
    protected readonly _refresh: (args: {
        keepPageInfo: boolean;
        keepModifications?: boolean;
    }) => Promise<FieldInternalValue<T>>;
    protected readonly _focus: (row?: number, nestedField?: string) => void;
    static readonly defaultUiProperties: Partial<ReadonlyFieldProperties<any>>;
    constructor(properties: FieldControlObjectConstructorProps<T>);
    /** Refreshes the field's value from the server. */
    refresh(): Promise<void>;
    protected _redraw(columnBind?: string): Promise<void>;
    /** The helper text underneath the field */
    helperText?: string;
    /** Whether the field helper text is hidden or not. Defaults to false */
    isHelperTextHidden?: boolean;
    /** Whether the value is bound only to GraphQL mutations (isTransientInput = true) or not (isTransientInput = false). Defaults to false */
    isTransientInput?: boolean;
    /**
     * Whether the HTML element is editable (disabled = false) or not (disabled = true)
     *
     * The difference with readOnly is that disabled suggests that the field is not editable
     * for some validation reason (e.g. a button which can be clicked due to validation errors)
     */
    isDisabled?: boolean;
    /** Field's value */
    get value(): FieldValue<T, N> | null;
    /** Field's value */
    set value(newValue: FieldValue<T, N> | null);
    /**
     * Fetch default values from the server even if the field is dirty.
     * If the `skipSet` argument is set to true, the values are requested from the server but not applied to the page.
     */
    fetchDefault(skipSet?: boolean): Promise<FieldInternalValue<T, N>>;
    /** Moves the browser focus to this field */
    focus(): void;
    /** Returns the next field compared to the position of this field instance */
    getNextField(isFocusable?: boolean): ReadonlyFieldControlObject<CT, any, any> | null;
}
//# sourceMappingURL=readonly-field-control-object.d.ts.map