/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import { GridNestedFieldTypes } from '@sage/xtrem-shared';
import type { Extend } from '../service/page-extension';
import type { ScreenBase } from '../service/screen-base';
import type { ScreenExtension } from '../types';
import type { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties, NestedTechnicalProperties, NestedTextAreaProperties, NestedTextProperties } from './nested-fields-properties';
import { FieldKey } from './types';
export { GridNestedFieldTypes };
export type NestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.MultiDropdown | FieldKey.MultiReference | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text | FieldKey.TextArea;
export type PodNestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.MultiDropdown | FieldKey.MultiReference | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text | FieldKey.TextArea;
export declare const allowedMainFieldTypes: GridNestedFieldTypes[];
export type NestedFieldComponentProps<T extends NestedFieldTypes, CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any, R extends ClientNode = any> = T extends FieldKey.Aggregate ? NestedAggregateProperties<CT, NodeType> : T extends FieldKey.Checkbox ? NestedCheckboxProperties<CT, NodeType> : T extends FieldKey.Count ? NestedCountProperties<CT, NodeType> : T extends FieldKey.Date ? NestedDateProperties<CT, NodeType> : T extends FieldKey.FilterSelect ? NestedFilterSelectProperties<CT, NodeType, R> : T extends FieldKey.Icon ? NestedIconProperties<CT, NodeType> : T extends FieldKey.Image ? NestedImageProperties<CT, NodeType> : T extends FieldKey.Label ? NestedLabelProperties<CT, NodeType> : T extends FieldKey.Link ? NestedLinkProperties<CT, NodeType> : T extends FieldKey.Numeric ? NestedNumericProperties<CT, NodeType> : T extends FieldKey.MultiDropdown ? NestedMultiDropdownProperties<CT, NodeType> : T extends FieldKey.DropdownList ? NestedDropdownListProperties<CT, NodeType> : T extends FieldKey.MultiReference ? NestedMultiReferenceProperties<CT, NodeType, R> : T extends FieldKey.Progress ? NestedProgressProperties<CT, NodeType> : T extends FieldKey.Reference ? NestedReferenceProperties<CT, NodeType, R> : T extends FieldKey.RelativeDate ? NestedRelativeDateProperties<CT, NodeType> : T extends FieldKey.Select ? NestedSelectProperties<CT, NodeType> : T extends FieldKey.Switch ? NestedSwitchProperties<CT, NodeType> : T extends FieldKey.Text ? NestedTextProperties<CT, NodeType> : T extends FieldKey.TextArea ? NestedTextAreaProperties<CT, NodeType> : NestedTextProperties<CT, NodeType>;
export type NestedFieldTypesWithoutTechnical = Exclude<NestedFieldTypes, FieldKey.Technical>;
export declare function isInstanceOf<T>(argument: any, C: new (...args: any[]) => T): argument is T;
export declare function isNestedTechnical<NodeType extends ClientNode = any>(argument: NestedField<ScreenBase, NestedFieldTypes, NodeType>): argument is NestedField<any, FieldKey.Technical, NodeType>;
export declare function withoutNestedTechnical<NodeType extends ClientNode = any>(argument?: NestedField<ScreenBase, NestedFieldTypes, NodeType>[]): NestedField<ScreenBase, Exclude<NestedFieldTypes, FieldKey.Technical>, NodeType>[];
export interface NestedField<CT extends ScreenExtension<CT>, T extends Partial<NestedFieldTypes>, NodeType extends ClientNode = any, R extends ClientNode = any> {
    defaultUiProperties: NestedFieldsProperties<T, Extend<CT>, NodeType, R>;
    properties: NestedFieldsProperties<T, Extend<CT>, NodeType, R>;
    type: T;
}
export interface NestedFieldTypeMap<CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any> {
    [FieldKey.Aggregate]: NestedAggregateProperties<CT, NodeType>;
    [FieldKey.Checkbox]: NestedCheckboxProperties<CT, NodeType>;
    [FieldKey.Count]: NestedCountProperties<CT, NodeType>;
    [FieldKey.Date]: NestedDateProperties<CT, NodeType>;
    [FieldKey.DropdownList]: NestedDropdownListProperties<CT, NodeType>;
    [FieldKey.FilterSelect]: NestedFilterSelectProperties<CT, NodeType, R>;
    [FieldKey.Icon]: NestedIconProperties<CT, NodeType>;
    [FieldKey.Image]: NestedImageProperties<CT, NodeType>;
    [FieldKey.Label]: NestedLabelProperties<CT, NodeType>;
    [FieldKey.Link]: NestedLinkProperties<CT, NodeType>;
    [FieldKey.MultiDropdown]: NestedMultiDropdownProperties<CT, NodeType>;
    [FieldKey.MultiReference]: NestedMultiReferenceProperties<CT, NodeType, R>;
    [FieldKey.Numeric]: NestedNumericProperties<CT, NodeType>;
    [FieldKey.Progress]: NestedProgressProperties<CT, NodeType>;
    [FieldKey.Reference]: NestedReferenceProperties<CT, NodeType, R>;
    [FieldKey.RelativeDate]: NestedRelativeDateProperties<CT, NodeType>;
    [FieldKey.Select]: NestedSelectProperties<CT, NodeType>;
    [FieldKey.Switch]: NestedSwitchProperties<CT, NodeType>;
    [FieldKey.Technical]: NestedTechnicalProperties<CT, NodeType, R>;
    [FieldKey.Text]: NestedTextProperties<CT, NodeType>;
    [FieldKey.TextArea]: NestedTextAreaProperties<CT, NodeType>;
}
export type NestedFieldsProperties<T extends NestedFieldTypes, CT extends ScreenBase = any, NodeType extends ClientNode = any, R extends ClientNode = any> = {
    [K in keyof NestedFieldTypeMap<CT, NodeType, R>]: K extends T ? NestedFieldTypeMap<CT, NodeType, R>[K] : never;
}[keyof {
    [K in keyof NestedFieldTypeMap<CT, NodeType, R>]: K extends T ? NestedFieldTypeMap<CT, NodeType, R>[K] : never;
}];
export interface NestedFieldHandlersArguments {
    onClick?: any[];
    onChange?: any[];
    rowValue?: any;
}
export declare const getNestedFieldDefaultProperties: <T extends NestedFieldTypes = FieldKey.Text, CT extends ScreenBase<any, any> = ScreenBase<any, any>, NodeType extends ClientNode = any, R extends ClientNode = any>(defaultProperties: any, controlObjectType?: T) => NestedFieldComponentProps<T, Extend<CT>, NodeType, R>;
export declare const aggregate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedAggregateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Aggregate, NodeType>;
export declare const checkbox: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Checkbox, NodeType>;
export declare const count: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCountProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Count, NodeType>;
export declare const date: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Date, NodeType>;
export declare const dropdownList: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDropdownListProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.DropdownList, NodeType>;
export declare const filterSelect: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedFilterSelectProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.FilterSelect, NodeType, R>;
export declare const icon: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedIconProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Icon, NodeType>;
export declare const image: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedImageProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Image, NodeType>;
export declare const label: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLabelProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Label, NodeType>;
export declare const link: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLinkProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Link, NodeType>;
export declare const numeric: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedNumericProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Numeric, NodeType>;
export declare const progress: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedProgressProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Progress, NodeType>;
export declare const reference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedReferenceProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.Reference, NodeType, R>;
export declare const relativeDate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedRelativeDateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.RelativeDate, NodeType>;
export declare const multiReference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiReferenceProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.MultiReference, NodeType, R>;
export declare const multiDropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiDropdownProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.MultiDropdown, NodeType, R>;
export declare const select: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSelectProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Select, NodeType>;
declare const nestedSwitch: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSwitchProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Switch, NodeType>;
export { nestedSwitch as switch };
export declare const text: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Text, NodeType>;
export declare const textArea: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextAreaProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.TextArea, NodeType>;
export declare const technical: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, ReferenceNode extends ClientNode = any>(properties: Omit<NestedTechnicalProperties<Extend<CT>, NodeType, ReferenceNode>, '_controlObjectType'>) => NestedField<CT, FieldKey.Technical, NodeType, ReferenceNode>;
//# sourceMappingURL=nested-fields.d.ts.map