import type { FilterParameter } from '@sage/xtrem-ui-components';
import type { Edge, Node } from 'reactflow';
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { OverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ValueOrCallback } from '../../../utils/types';
import type { BlockControlObject, SectionControlObject } from '../../control-objects';
import type { EditableFieldProperties } from '../../editable-field-control-object';
import type { FieldControlObjectInstance } from '../../types';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { Changeable, Clickable, ExtensionField, HasParent } from '../traits';
import type { Dict, WorkflowVariable } from '@sage/xtrem-shared';
export interface DefaultDataType extends Dict<any> {
    type?: string;
    subtitle?: string;
    details?: string;
    variables?: WorkflowVariable[];
}
export interface WorkflowFieldValue {
    edges: Edge[];
    nodes: Node<{
        screenId?: string;
        elementId?: string;
    }>[];
}
export interface WorkflowDecoratorProperties<CT extends ScreenBase = ScreenBase> extends WorkflowProperties<CT>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
    /** The parameters of the form editor */
    parameters?: ValueOrCallback<CT, FilterParameter[]>;
}
export interface WorkflowExtensionDecoratorProperties<CT extends ScreenExtension<CT>> extends OverrideDecoratorProperties<WorkflowDecoratorProperties<Extend<CT>>> {
}
export interface WorkflowProperties<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldProperties<CT> {
}
export type WorkflowComponentProperties = BaseEditableComponentProperties<WorkflowProperties, WorkflowFieldValue>;
//# sourceMappingURL=workflow-types.d.ts.map