import type { Edge, Node } from 'reactflow';
import type { DefaultDataType } from './workflow-types';
import type { WorkflowVariable } from '@sage/xtrem-shared';
export declare const edgeStyle: Partial<Edge>;
export declare const removeTransientNodeDataProperties: (data: DefaultDataType) => DefaultDataType;
export declare const removeTransientNodeDataPropertiesFromNodes: (nodes: Node<DefaultDataType>[]) => Node[];
export declare const removeTransientEdgeDataPropertiesFromEdges: (nodes: Edge<DefaultDataType>[]) => Edge[];
export declare const changeEventHandler: (screenId: string, elementId: string) => () => Promise<void>;
export declare const usePreviousWorkflowNodes: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => Node<DefaultDataType>[];
export declare const useSourceNode: (edgeId: string, screenId?: string, elementId?: string) => Node<DefaultDataType> | null;
export declare const useWorkflowNodeVariables: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => WorkflowVariable[];
export declare function removeChildNodesAndEdgesFromStartPoint(nodeId: string, tempEdges: Edge[], tempNodes: Node[]): void;
export declare function allocateId(prefix: string, items: {
    id: string;
}[]): string;
//# sourceMappingURL=workflow-component-utils.d.ts.map