/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { VisualProcessDecoratorProperties } from './visual-process-types';
/**
 * Initializes the decorated member as a [VisualProcess]{@link VisualProcessControlObject} field with the provided properties
 *
 * @param properties The properties that the [VisualProcess]{@link VisualProcessControlObject} field will be initialized with
 */
export declare function visualProcessField<T extends ScreenExtension<T>>(properties: VisualProcessDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function visualProcessFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<VisualProcessDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=visual-process-decorator.d.ts.map