import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { ToggleControlObject } from './toggle-control-object';
class ToggleDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = ToggleControlObject;
    }
    static { this.defaultUiProperties = {
        ...ToggleControlObject.defaultUiProperties,
    }; }
}
/**
 * Initializes the decorated member as a [Separator]{@link SeparatorControlObject} field with the provided properties
 *
 * @param properties The properties that the [Separator]{@link SeparatorControlObject} field will be initialized with
 */
export function toggleField(properties) {
    return standardDecoratorImplementation(properties, ToggleDecorator, FieldKey.Toggle);
}
export function toggleFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=toggle-decorator.js.map