import ButtonToggle from 'carbon-react/esm/components/button-toggle/button-toggle.component';
import ButtonToggleGroup from 'carbon-react/esm/components/button-toggle/button-toggle-group';
import React, { useRef } from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { getDataTestIdAttribute } from '../../../utils/dom';
import { triggerFieldEvent } from '../../../utils/events';
import { useFocus } from '../../../utils/hooks/effects/use-focus';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { addOptionsAndLocalizationToProps, splitValueToMergedValue } from '../../../utils/transformers';
import { isFieldDisabled, isFieldReadOnly } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { HelperText } from '../carbon-utility-components';
export function ToggleComponent(props) {
    const { title, options, isTitleHidden } = props.fieldProperties;
    const firstToggleButtonRef = useRef(null);
    useFocus(firstToggleButtonRef, props.isInFocus, 'input');
    const ToggleButtonGroupProps = {
        label: title && !isTitleHidden ? title : '',
        groupName: props.elementId,
        name: props.elementId,
        value: props.value,
        onChange: (_evt, value) => handleChange(props.elementId, value, props.setFieldValue, props.validate, triggerChangeListener(props.screenId, props.elementId)),
    };
    const optionsToUse = props.enumOptions ||
        resolveByValue({
            propertyValue: options,
            skipHexFormat: true,
            screenId: props.screenId,
            fieldValue: props.value,
            rowValue: props.handlersArguments?.rowValue
                ? splitValueToMergedValue(props.handlersArguments?.rowValue)
                : props.handlersArguments?.rowValue,
        }) ||
        [];
    const isReadOnly = isFieldReadOnly(props.screenId, props.fieldProperties, props.value, props.handlersArguments?.rowValue) ||
        isFieldDisabled(props.screenId, props.fieldProperties, props.value, props.handlersArguments?.rowValue);
    return (React.createElement(CarbonWrapper, { noReadOnlySupport: true, ...props, className: "e-toggle-field", componentName: "Toggle", value: props.value },
        React.createElement(ButtonToggleGroup, { id: "e-toggle-button-group", "data-testid": getDataTestIdAttribute('Toggle-component', 'Toggle-button-group', props.elementId), ...ToggleButtonGroupProps, label: ToggleButtonGroupProps.label }, optionsToUse.map(option => renderToggleButton(option, props.elementId, props.onFocus, props.fieldProperties.size || 'small', resolveByValue({
            propertyValue: props.fieldProperties.mapIcon,
            rowValue: props.handlersArguments?.rowValue
                ? splitValueToMergedValue(props.handlersArguments?.rowValue)
                : props.handlersArguments?.rowValue,
            fieldValue: option,
            screenId: props.screenId,
            skipHexFormat: true,
        }), props.fieldProperties.isGrouped, props.localizedOptions, resolveByValue({
            propertyValue: props.fieldProperties.map,
            rowValue: props.handlersArguments?.rowValue
                ? splitValueToMergedValue(props.handlersArguments?.rowValue)
                : props.handlersArguments?.rowValue,
            fieldValue: option,
            screenId: props.screenId,
            skipHexFormat: true,
        }), isReadOnly))),
        React.createElement(HelperText, { helperText: props.fieldProperties.helperText })));
}
const triggerChangeListener = (screenId, elementId) => () => {
    triggerFieldEvent(screenId, elementId, 'onChange');
};
const renderToggleButton = (value, elementId, onFocus, size, buttonIcon, isGrouped = false, localizedOptions, mappedText, isDisabled = false) => {
    const label = localizedOptions && localizedOptions[value] ? localizedOptions[value] : mappedText || value;
    const carbonToggleProps = {
        value,
        label,
        size,
        key: value,
        disabled: isDisabled,
    };
    return (React.createElement(ButtonToggle, { grouped: isGrouped, onFocus: onFocus, "data-testid": getDataTestIdAttribute('toggle-component', 'Toggle-button', elementId), buttonIcon: buttonIcon, ...carbonToggleProps }, label));
};
export const ConnectedToggleComponent = connect((state, externalProps) => addOptionsAndLocalizationToProps(state, mapStateToProps()(state, externalProps)), mapDispatchToProps())(ToggleComponent);
export default ConnectedToggleComponent;
//# sourceMappingURL=toggle-component.js.map