/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export declare class TimeControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Time, FieldComponentProps<FieldKey.Time>> {
    /** The helper text underneath the field */
    helperText?: string;
    /** Moves the browser focus to this field */
    focus(): void;
    get hours(): number | null;
    set hours(value: number);
    get minutes(): number | null;
    set minutes(value: number);
    get seconds(): number | null;
    set seconds(value: number);
    get value(): string | null;
    set value(value: string | null);
}
//# sourceMappingURL=time-control-object.d.ts.map