import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { TextDecoratorProperties } from './text-types';
/**
 * Initializes the decorated member as a [Text]{@link TextControlObject} field with the provided properties
 *
 * @param properties The properties that the [Text]{@link TextControlObject} field will be initialized with
 */
export declare function textField<T extends ScreenExtension<T>>(properties: TextDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function textFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<TextDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=text-decorator.d.ts.map