import Textbox from 'carbon-react/esm/components/textbox';
import { debounce } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { getCommonCarbonComponentProperties } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
export class TextComponent extends EditableFieldBaseComponent {
    constructor(props) {
        super(props);
        this.onInputValueChanged = debounce(async (searchText) => {
            await triggerFieldEvent(this.props.screenId, this.props.elementId, 'onInputValueChange', searchText);
        }, 150);
        this.onChange = async (event) => {
            this.setState({ isDirty: true, value: event.target.value });
            await this.onInputValueChanged(event.target.value);
        };
        this.onBlur = () => {
            const carbonProps = getCommonCarbonComponentProperties(this.props);
            carbonProps.onBlur();
            const newValue = this.state.value || null;
            const propsValue = this.props.value || null;
            if (propsValue !== newValue) {
                handleChange(this.props.elementId, newValue, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.onKeyDown = (event) => {
            if (event.key === 'Enter') {
                this.onBlur();
            }
            if (event.key === 'Escape') {
                this.setState({ value: this.props.value ? String(this.props.value) : '' });
            }
        };
        this.onKeyUp = (event) => {
            this.handleSelection(event);
        };
        this.onClick = (event) => {
            this.getClickHandler()();
            this.handleSelection(event);
        };
        this.handleFocus = (event) => {
            this.handleSelection(event);
            if (!this.props.isInFocus) {
                const carbonProps = getCommonCarbonComponentProperties(this.props);
                carbonProps.onFocus();
            }
        };
        this.handleSelection = (event) => {
            if (!this.state.isDirty && this.props.fieldProperties.isPassword) {
                event.target.setSelectionRange(0, 0);
                event.target.focus();
                event.target.select();
            }
        };
        this.state = {
            value: this.props.value ? String(this.props.value) : '',
            isDirty: false,
        };
    }
    UNSAFE_componentWillReceiveProps(nextProps) {
        const value = nextProps.value;
        if (this.state.value !== value) {
            this.setState({ isDirty: false, value: value ? String(value) : '' });
        }
    }
    render() {
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-text-field", componentName: "text", componentRef: this.componentRef, handlersArguments: this.props.handlersArguments, noReadOnlySupport: true, value: this.state.value },
            React.createElement(Textbox, { ...getCommonCarbonComponentProperties(this.props), "data-testid": "e-text-field-input", inputIcon: this.props.fieldProperties.icon, onBlur: this.onBlur, onChange: this.onChange, onClick: this.onClick, onKeyDown: this.onKeyDown, onKeyUp: this.onKeyUp, value: this.state.value || '', type: this.props.fieldProperties.isPassword ? 'password' : undefined, onFocus: this.handleFocus })));
    }
}
export const ConnectedTextComponent = connect(mapStateToProps(), mapDispatchToProps())(TextComponent);
export default ConnectedTextComponent;
//# sourceMappingURL=text-component.js.map