import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedTextComponent = React.lazy(() => import('./text-component'));
export function AsyncConnectedTextComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedTextComponent, { ...props })));
}
const TextComponent = React.lazy(() => import('./text-component').then(c => ({ default: c.TextComponent })));
export function AsyncTextComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(TextComponent, { ...props })));
}
//# sourceMappingURL=async-text-component.js.map