import type { CellFocusedEvent, CellKeyDownEvent, ColDef, Column, ColumnEverythingChangedEvent, ColumnState, GridApi } from '@ag-grid-community/core';
import type { Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import type { TableViewGrouping, TableViewSortedColumn } from '../../../redux/state';
import type { CollectionValueType } from '../../../service/collection-data-types';
import { ContextType } from '../../../types';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { CalendarView } from '../../ui/calendar-body/calendar-body-types';
import type { InternalTableProperties, SelectedGroupState, TableInternalComponentProps } from './table-component-types';
import type { AgGridColumnConfigWithScreenIdAndColDef } from '../../../utils/ag-grid/ag-grid-utility-types';
interface ResizedColumn {
    key: string | Column;
    newWidth: number;
}
interface TableDesktopState {
    autoGroupColumnDef?: ColDef;
    columns: AgGridColumnConfigWithScreenIdAndColDef[];
    columnStates?: ColumnState[];
    groupByColumn?: AgGridColumnConfigWithScreenIdAndColDef;
    hasFloatingFilters: boolean;
    isConfigurationDialogOpen?: boolean;
    isExportingExcel: boolean;
    isSelectAllChecked: boolean;
    phantomRows: {
        _id: string;
    }[];
    selectedRowCount: number;
    selectedRows: CollectionValueType[];
    tableHasData: boolean;
    selectedGroupState?: SelectedGroupState;
    selectedCalendarView: CalendarView;
    resizedColumns: ResizedColumn[];
}
export declare class DesktopTableComponent extends React.Component<TableInternalComponentProps, TableDesktopState> {
    private gridApi;
    private readonly gridId;
    private dataOperationMode;
    private readonly autoSizeStrategy;
    private isFetching;
    private isFilteringErrors;
    private newDataSelected;
    private actionSubscription;
    private collectionValueChangeSubscription;
    private collectionValidityChangeSubscription;
    protected containerRef: React.RefObject<HTMLDivElement>;
    private readonly defaultColDef;
    private readonly loadingCellRendererParams;
    private readonly loadingOverlayComponentParams;
    constructor(props: TableInternalComponentProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: TableInternalComponentProps): void;
    componentWillUnmount(): void;
    private readonly getRowNode;
    private readonly focusPhantomRowAndStartEditing;
    private readonly onCollectionUpdated;
    private getCursor;
    private getFilters;
    private readonly resetOptionsMenu;
    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
     * event
     **/
    private readonly selectTableItems;
    private readonly insertDataSourceIntoTable;
    private readonly updateColumnValidation;
    private readonly getUnknownLastRow;
    private readonly getRowCount;
    private readonly isNavigationPanel;
    /**
     * Ag-grid callback which is triggered whenever the table component needs new data from our framework
     * @param getRowsParams
     */
    private readonly getRows;
    private readonly serverSideDataSource;
    private readonly isDisabled;
    private readonly isReadOnly;
    private readonly resizeListener;
    /**
     * Ag-grid lifecycle event listener. It is triggered when the table is prepared with the initial rendering of the
     * controller components and is ready to receive data.
     **/
    private readonly onGridReady;
    private readonly setPhantomRow;
    /**
     * Gets the IDs of all rows that have been selected.
     *
     * @private
     * @memberof DesktopTableComponent
     */
    private readonly getSelectedIds;
    private readonly onSelectAll;
    private readonly onUnselectAll;
    private readonly onSwitchView;
    private readonly onSwitchCalendarView;
    private readonly updateSelectedRows;
    private readonly processSelectedGroupState;
    private readonly toggleFullGroupSelection;
    private readonly handleRowSelection;
    private readonly notifyNewSelection;
    /**
     * Event listener, triggered when the user clicks the checkbox on the front of the row. Both for selection and
     * deselection.
     * */
    private readonly onSelectionChange;
    private readonly handleFilterChanged;
    private readonly handleColumnRowGroupChanged;
    private readonly setShouldResetTable;
    private readonly onOptionsMenuItemChange;
    private readonly getRowId;
    private readonly onViewportChanged;
    private readonly getRowClass;
    private readonly gridOptions;
    private readonly getColumnDefinitions;
    private readonly hasFilterableColumns;
    private readonly toggleFloatingFilters;
    private readonly exportToExcelWithInfiniteScroll;
    private readonly exportToExcelWithPagination;
    private readonly exportToExcel;
    private readonly getCacheBlockSize;
    private readonly isServerSideGroup;
    private readonly excludeInternalColumnsFilter;
    private readonly getAllColumnIds;
    private readonly getAllDisplayedColumnIds;
    autoSizeAllColumns: (gridApi?: GridApi | null) => void;
    private readonly onFirstDataRendered;
    private readonly canBeGroupedBy;
    private readonly ungroupByColumn;
    private readonly groupByColumn;
    private readonly updateColDefsStates;
    private readonly sortColumns;
    private readonly getGroupByMenuItem;
    private readonly getMainMenuItems;
    onCellFocused: (params: CellFocusedEvent) => void;
    onCellKeyDown: (event: CellKeyDownEvent) => void;
    getAllNotVisibleNotHiddenColumns: (tableProperties: InternalTableProperties) => string[];
    hideUnhideColumns: (event?: ColumnEverythingChangedEvent) => void;
    isColumnHidden: (colBind?: string) => boolean;
    onFilterByErrors: () => Promise<void>;
    onUnsetFilterByErrors: () => Promise<void>;
    getDefaultHeight: () => number;
    private readonly adjustTableHeight;
    /**
     * This method is triggered if the user clicks or tabs outside the table. If this happens we want to stop editing the cell in order
     * to trigger onCellEditingStopped from ag-grid.
     */
    private readonly onBlurTable;
    private readonly clearSelection;
    initColumnState(): Promise<void>;
    updateColumnState(): Promise<void>;
    private readonly onColumnPanelHiddenStateChange;
    private readonly onColumnPanelOrderChangeChange;
    private readonly onSortChanged;
    renderCalendarView(): React.ReactNode;
    private readonly onCellClicked;
    private readonly onCellEditingStopped;
    private readonly onColumnResized;
    private readonly onOpenColumnPanel;
    private readonly onCloseColumnPanel;
    private readonly noRowsOverlayComponentParams;
    private readonly onRowClicked;
    private readonly rowClassRules;
    private readonly isInfiniteScroll;
    render(): React.ReactNode;
}
export declare const ConnectedDesktopTableComponent: import("react-redux").ConnectedComponent<typeof DesktopTableComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DesktopTableComponent> | undefined;
    accessBindings: import("../../../service/page-definition").AccessBindings;
    additionalLookupRecords?: (() => import("../../types").PartialCollectionValueWithIds<any>[]) | undefined;
    activeLookupDialog?: import("../../../redux/state").FocusPosition | null | undefined;
    api?: GridApi<any> | undefined;
    bulkActions?: import("../../control-objects").BulkAction[] | undefined;
    canDragCard?: boolean | undefined;
    contextType?: ContextType | undefined;
    dataTypes: Dict<import("../../../service/metadata-types").DataTypeDetails>;
    elementId: string;
    emptyStateClickableText?: string | undefined;
    emptyStateText?: string | undefined;
    enumTypes: Dict<string[]>;
    errorMessage?: string | undefined;
    fieldProperties: InternalTableProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>;
    filterModel?: any;
    fixedHeight?: number | undefined;
    graphApi?: import("../../..").GraphQLApi<any> | undefined;
    groupByField?: any;
    groupTitle?: string | undefined;
    isAutoSelectEnabled?: boolean | undefined;
    isInFocus?: boolean | undefined;
    isNavPanel?: boolean | undefined;
    isParentDisabled?: boolean | undefined;
    isReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean> | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    locale: import("@sage/xtrem-shared").LocalizeLocale;
    lookupSelectionMode?: "multiple" | "single" | undefined;
    nodeTypes: Dict<import("../../../service/metadata-types").FormattedNodeDetails>;
    numberOfVisibleRows?: number | undefined;
    onEmptyStateClickableText?: (() => void) | undefined;
    onFocus?: ((screenId: string, elementId: string, row: string, nestedField: string) => void) | undefined;
    onRowClick?: import("./table-component-types").OnRowClickFunction | undefined;
    recordContext?: any;
    openedRecordId?: string | number | null | undefined;
    pageNode?: import("../../../types").NodePropertyType | undefined;
    screenId: string;
    searchText?: string | undefined;
    selectedRecordId?: string | number | boolean | undefined;
    selectedOptionsMenuItem?: OptionsMenuItem<any> | undefined;
    setFieldProperties?: ((elementId: string, properties: InternalTableProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>) => void) | undefined;
    setGlobalLoading?: ((setGlobalLoading: boolean) => void) | undefined;
    setTableViewColumnHidden?: ((level: number, columnHidden?: Dict<boolean> | undefined) => void) | undefined;
    setTableViewColumnOrder?: ((level: number, columnOrder?: string[] | undefined) => void) | undefined;
    setTableViewFilter?: ((level: number, filter?: any) => void) | undefined;
    setTableViewGrouping?: ((level: number, grouping?: TableViewGrouping | undefined) => void) | undefined;
    setTableViewOptionsMenuItem?: ((level: number, optionsMenuItem?: OptionsMenuItem<any> | undefined) => void) | undefined;
    setTableViewSearchText?: ((level: number, searchText: string) => void) | undefined;
    setTableViewSortOrder?: ((level: number, sortOrder?: TableViewSortedColumn[] | undefined) => void) | undefined;
    setTableViewOptionsMenuItemAndViewFilter?: ((level: number, optionsMenuItem?: OptionsMenuItem<any> | undefined, filter?: any) => void) | undefined;
    tableViews?: Dict<import("../../../redux/state").TableView> | undefined;
    username?: string | undefined;
    validationErrors: import("../../../service/screen-base-definition").ValidationResult[];
    value: import("../../../service/collection-data-service").CollectionValue<any>;
    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedDesktopTableComponent;
//# sourceMappingURL=desktop-table-component.d.ts.map