import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedTableComponent = React.lazy(() => import('./table-component'));
export function AsyncConnectedTableComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedTableComponent, { ...props })));
}
const TableComponent = React.lazy(() => import('./table-component').then(c => ({ default: c.TableComponent })));
export function AsyncTableComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(TableComponent, { ...props })));
}
//# sourceMappingURL=async-table-component.js.map