import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import { CollectionValueControlObject } from '../collection-value-field';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
 */
export class TableSummaryControlObject extends CollectionValueControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
    }; }
    /** Return records that the user just added to this table and not yet known by the server. */
    getNewRecords() {
        this.ensureFieldHasValue();
        const value = this._getValue();
        if (!value) {
            return [];
        }
        return value.getNewRecords();
    }
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    /** Redraws the current table view, this function can be useful when values are updated that are used in property callbacks. */
    redraw(columnBind) {
        return this._redraw(columnBind);
    }
}
//# sourceMappingURL=table-summary-control-object.js.map