import * as React from 'react';
import { connect } from 'react-redux';
import { withoutNestedTechnical } from '../../nested-fields';
import { getFieldTitle } from '../carbon-helpers';
import Label from 'carbon-react/esm/__internal__/label';
import { TableSummaryRowComponent } from './table-summary-row-component';
import { getNestedFieldElementId } from '../../../utils/abstract-fields-utils';
import { HelperText } from '../carbon-utility-components';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { ContextType } from '../../../types';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { withCollectionValueSubscription } from '../../connected-collection';
import { localize } from '../../../service/i18n-service';
import { FieldKey } from '../../types';
import { splitValueToMergedValue } from '../../../utils/transformers';
export class TableSummaryComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.getColumnHeaders = () => this.getVisibleColumns().map(col => {
            const title = resolveByValue({
                propertyValue: col.properties.title,
                screenId: this.props.screenId,
                skipHexFormat: true,
                rowValue: null,
                fieldValue: null,
            });
            const isRightAligned = [FieldKey.Numeric, FieldKey.Aggregate].includes(col.type);
            const elementId = getNestedFieldElementId(col);
            return (React.createElement("th", { className: isRightAligned ? 'e-table-summary-field-right-aligned-header' : undefined, key: elementId, "data-testid": `e-table-summary-field-header-${elementId}` },
                React.createElement("span", null, title)));
        });
        this.getVisibleColumns = () => withoutNestedTechnical(this.props.fieldProperties.columns).filter(r => !resolveByValue({
            propertyValue: r.properties.isHidden,
            screenId: this.props.screenId,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        }));
        this.getRows = () => {
            const rowsData = this.props.value?.getData() || [];
            const visibleColumns = this.getVisibleColumns();
            const defaultEmptyStateText = localize('@sage/xtrem-ui/table-summary-empty-default-text', 'There are no data to display');
            if (visibleColumns.length) {
                return rowsData.map(item => {
                    const commonProperties = {
                        _id: item._id,
                        contextType: ContextType.tableSummary,
                        screenId: this.props.screenId,
                        parentElementId: this.props.elementId,
                        setFieldValue: () => Promise.resolve(),
                        handlersArguments: { rowValue: splitValueToMergedValue(item) },
                    };
                    return (React.createElement(TableSummaryRowComponent, { key: item._id, value: this.props.value, recordId: item._id, columns: visibleColumns, commonProperties: commonProperties }));
                });
            }
            return (React.createElement("div", { className: "e-table-summary-field-empty" },
                React.createElement("span", { className: "e-table-summary-field-empty-message" }, localize('@sage/xtrem-ui/table-summary-empty-text', this.props.fieldProperties.emptyStateText) ||
                    defaultEmptyStateText)));
        };
    }
    render() {
        const title = getFieldTitle(this.props.screenId, this.props.fieldProperties, null);
        return (React.createElement("div", { ...this.getBaseAttributesDivWrapper('table-summary', 'e-table-summary-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested) },
            title && !this.props.fieldProperties.isTitleHidden && (React.createElement("div", { className: "e-field-title" },
                React.createElement(Label, { error: this.props.validationErrors?.[0]?.message, htmlFor: undefined }, title))),
            React.createElement("table", { className: "e-table-summary-field-table" },
                React.createElement("tbody", { className: "e-table-summary-field-body" },
                    React.createElement("tr", { key: "header", className: "e-table-summary-field-header", "data-testid": "e-table-summary-field-header" }, this.getColumnHeaders()),
                    this.getRows())),
            this.props.fieldProperties.helperText && (React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText }))));
    }
}
export const ConnectedTableSummaryComponent = connect(mapStateToProps(), mapDispatchToProps())(withCollectionValueSubscription(TableSummaryComponent));
export default ConnectedTableSummaryComponent;
//# sourceMappingURL=table-summary-component.js.map