/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { SwitchControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class SwitchDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = SwitchControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Switch]{@link SwitchControlObject} field with the provided properties
 *
 * @param properties The properties that the [Switch]{@link SwitchControlObject} field will be initialized with
 */
export function switchField(properties) {
    return standardDecoratorImplementation(properties, SwitchDecorator, FieldKey.Switch);
}
export function switchFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=switch-decorator.js.map