/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { SwitchDecoratorProperties } from './switch-types';
export { NestedSwitchProperties } from './switch-types';
/**
 * Initializes the decorated member as a [Switch]{@link SwitchControlObject} field with the provided properties
 *
 * @param properties The properties that the [Switch]{@link SwitchControlObject} field will be initialized with
 */
export declare function switchField<T extends ScreenExtension<T>>(properties: SwitchDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function switchFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<SwitchDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=switch-decorator.d.ts.map