import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
export { StaticContentProperties } from './static-content-types';
export declare class StaticContentControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.StaticContent, FieldComponentProps<FieldKey.StaticContent>> {
    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.StaticContent>>;
    /**
     * Support for the title property
     * When set, and title is also set, beside it, an Info icon appears
     * When hovered, titleHelp appears as a tooltip.
     */
    content?: string;
    maxVisibleLines?: number;
}
//# sourceMappingURL=static-content-control-object.d.ts.map