import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { SeparatorDecoratorProperties } from './separator-types';
/**
 * Initializes the decorated member as a [Separator]{@link SeparatorControlObject} field with the provided properties
 *
 * @param properties The properties that the [Separator]{@link SeparatorControlObject} field will be initialized with
 */
export declare function separatorField<T extends ScreenExtension<T>>(properties: SeparatorDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function separatorFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<SeparatorDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=separator-decorator.d.ts.map