import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { SelectionCardControlObject } from './selection-card-control-object';
class SelectionCardDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = SelectionCardControlObject;
    }
}
/**
 * Initializes the decorated member as a [SelectionCard]{@link SelectionCardControlObject} field with the provided properties
 *
 * @param properties The properties that the [SelectionCard]{@link SelectionCardControlObject} field will be initialized with
 */
export function selectionCard(properties) {
    return standardDecoratorImplementation(properties, SelectionCardDecorator, FieldKey.SelectionCard);
}
export function selectionCardOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=selection-card-decorator.js.map