import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
 */
export declare class SelectControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Select, FieldComponentProps<FieldKey.Select>> {
    /** The helper text underneath the field */
    helperText?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /** Indicator, whether sounds play on successful/erroneous selection */
    isSoundDisabled?: boolean;
    /** Options to be displayed in the select element */
    options?: string[];
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /**
     * The GraphQL node that the select options will be fetched from.
     * When using this property, the node must be an Enum
     */
    get optionType(): string | undefined;
    /** Moves the browser focus to this field */
    focus(): void;
    /** Field's value, only valid options can be set as value. */
    set value(newValue: ReferencedEnumType | null);
    /** Field's value, only valid options can be set as value. */
    get value(): ReferencedEnumType | null;
}
//# sourceMappingURL=select-control-object.d.ts.map