import { debounce } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { addOptionsAndLocalizationToProps } from '../../../utils/transformers';
import { Select } from '../../ui/select/select-component';
import { getCommonCarbonComponentProperties, getLabelTitle } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { createSelectItemFromOption, getItemsFromProps } from './select-utils';
import { resolveByValue } from '../../../utils/resolve-value-utils';
export class SelectComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onInputValueChanged = debounce(async (searchText) => {
            await triggerFieldEvent(this.props.screenId, this.props.elementId, 'onInputValueChange', searchText);
        }, 150);
        this.onChange = (selectedItem, isOrganicChange) => {
            if (isOrganicChange) {
                handleChange(this.props.elementId, selectedItem ? selectedItem.id : null, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.getItems = (searchText) => {
            if (this.props.fieldProperties.optionType) {
                const items = getItemsFromProps(this.props, searchText, this.props.recordContext) || [];
                return Promise.resolve(items);
            }
            if (this.props.fieldProperties.options) {
                const options = resolveByValue({
                    propertyValue: this.props.fieldProperties.options,
                    screenId: this.props.screenId,
                    skipHexFormat: true,
                    fieldValue: this.props.value,
                    rowValue: this.props.recordContext,
                });
                const items = options.map(option => createSelectItemFromOption(option, this.props));
                return Promise.resolve(items);
            }
            return Promise.resolve([]);
        };
    }
    static resolveDisplayValueFromProps(props, value = '') {
        const selectItem = createSelectItemFromOption(value, props);
        return selectItem.displayedAs || selectItem.value;
    }
    render() {
        const carbonProps = getCommonCarbonComponentProperties(this.props);
        const value = this.props.value ? createSelectItemFromOption(this.props.value, this.props) : undefined;
        const initialInputValue = SelectComponent.resolveDisplayValueFromProps(this.props, this.props.value);
        const label = !this.props.fieldProperties.isTitleHidden
            ? getLabelTitle(this.props.screenId, this.props.fieldProperties, this.props.handlersArguments?.rowValue)
            : undefined;
        const { fieldProperties: { isFullWidth, icon, placeholder, helperText, size }, onFocus, handlersArguments, } = this.props;
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-select-field", componentName: "select", componentRef: this.componentRef, handlersArguments: handlersArguments, helperText: helperText, noReadOnlySupport: true, value: this.props.value, readOnlyDisplayValue: initialInputValue },
            React.createElement(Select, { ...carbonProps, autoSelect: true, disabled: this.isDisabled(), elementId: this.props.elementId, fullWidth: isFullWidth, getItems: this.getItems, helperText: helperText, icon: icon, inputId: carbonProps.id, isSortedAlphabetically: this.props.fieldProperties.isSortedAlphabetically, label: label, minLookupCharacters: 0, noHelperTextInItem: true, onChange: this.onChange, onInputChange: this.onInputValueChanged, onInputFocus: onFocus, placeholder: placeholder, readOnly: this.isReadOnly(), refetchIfChanged: this.props.fieldProperties.options, screenId: this.props.screenId, selectedItem: value, size: size, testId: "e-select-field-input", isSoundDisabled: resolveByValue({
                    screenId: this.props.screenId,
                    propertyValue: this.props.fieldProperties.isSoundDisabled,
                    skipHexFormat: true,
                    fieldValue: null,
                    rowValue: null,
                }) })));
    }
}
export const ConnectedSelectComponent = connect((state, externalProps) => addOptionsAndLocalizationToProps(state, mapStateToProps()(state, externalProps)), mapDispatchToProps())(SelectComponent);
export default ConnectedSelectComponent;
//# sourceMappingURL=select-component.js.map