import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedRelativeDateComponent = React.lazy(() => import('./relative-date-component'));
export function AsyncConnectedRelativeDateComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedRelativeDateComponent, { ...props })));
}
const RelativeDateComponent = React.lazy(() => import('./relative-date-component').then(c => ({ default: c.RelativeDateComponent })));
export function AsyncRelativeDateComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(RelativeDateComponent, { ...props })));
}
//# sourceMappingURL=async-relative-date-component.js.map