import type { ClientNode } from '@sage/xtrem-client';
import type { ContextType } from '../../../types';
import type { CollectionItem, OrderByType } from '../../types';
import type { SelectItem } from '../../ui/select/select-component';
import type { ReferenceDecoratorProperties, ReferenceProperties } from './reference-types';
type FieldProps<T extends ClientNode = any> = Pick<ReferenceDecoratorProperties<any, T>, 'helperText' | 'columns' | 'isHelperTextHidden' | 'valueField' | 'imageField' | 'helperTextField' | 'tunnelPageIdField' | 'tunnelPage'>;
export declare function getReferenceImage<T extends ClientNode = any>({ value, fieldProperties: { imageField }, }: {
    value?: T;
    fieldProperties: FieldProps<T>;
}): SelectItem['image'];
export declare function getReferenceSearchText<T extends ClientNode = any>({ value, fieldProperties: { valueField }, }: {
    value?: T;
    fieldProperties: FieldProps<T>;
}): string;
export declare function getReferenceHelperText<T extends ClientNode = any>({ value, fieldProperties: { helperTextField, helperText }, }: {
    value?: T;
    fieldProperties: FieldProps<T>;
}): string | undefined;
export declare function getReferenceTunnelLinkId<T extends ClientNode = any>({ fieldProperties, value, }: {
    fieldProperties: FieldProps<T>;
    value?: T;
}): string | undefined;
export declare function isReferenceDisabled<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, }: {
    screenId: string;
    fieldProperties: FieldProps<T>;
    value?: T;
    rowValue?: any;
}): boolean;
export declare function isReferenceReadOnly<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
    screenId: string;
    fieldProperties: FieldProps<T>;
    value?: T;
    rowValue?: any;
    contextType?: ContextType;
}): boolean;
export declare function hasHelperTextField<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
    screenId: string;
    fieldProperties: FieldProps<T>;
    value?: T;
    rowValue?: any;
    contextType?: ContextType;
}): boolean;
export declare function hasLookupIcon<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
    screenId: string;
    fieldProperties: FieldProps<T>;
    value?: T | T[];
    rowValue: any;
    contextType?: ContextType;
}): boolean;
export declare function getReferenceSelectedRecord<T extends ClientNode = any>({ value, fieldProperties, }: {
    value?: T;
    fieldProperties: FieldProps<T>;
}): SelectItem | undefined;
export declare function nodeToSelectItem<T extends ClientNode = any>({ collectionItem, fieldProperties: { valueField, helperTextField, imageField }, }: {
    fieldProperties: FieldProps<T>;
    collectionItem: CollectionItem;
}): SelectItem;
export declare function nodesToSelectItems<T extends ClientNode = any>({ nodes, fieldProperties, }: {
    nodes?: CollectionItem[];
    fieldProperties: FieldProps<T>;
}): SelectItem[];
export declare const getReferenceValueField: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => string;
export declare const getReferenceValueFieldPath: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => string;
export declare const getReferenceOrderBy: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => OrderByType<T>;
export declare function getReferencePath<T extends ClientNode = any>(value: ReferenceProperties<any, T>['valueField']): string;
export declare function getReferencePath<T extends ClientNode = any>(value: ReferenceProperties<any, T>['helperTextField']): string;
export declare const isStringReferenceValueField: (valueField: ReferenceProperties<any, any>['valueField']) => boolean;
export {};
//# sourceMappingURL=reference-utils.d.ts.map