/**
 * @packageDocumentation
 * @module root
 * */
import { addColumnsToProperties, addDisabledToProperties, addHelperTextFieldToProperties, addImageFieldToProperties, addNodeToProperties, addTunnelPageToProperties, addValueFieldToProperties, } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ReferenceControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ReferenceDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = ReferenceControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addNodeToProperties({ dataType, propertyDetails, properties });
        addColumnsToProperties({
            dataType,
            propertyDetails,
            properties,
            dataTypes: this.dataTypes,
            nodeTypes: this.nodeTypes,
        }, true);
        addValueFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addHelperTextFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addImageFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addTunnelPageToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [Reference]{@link ReferenceControlObject} field with the provided properties
 *
 * @param properties The properties that the [Reference]{@link ReferenceControlObject} field will be initialized with
 */
export function referenceField(properties) {
    return standardDecoratorImplementation(properties, ReferenceDecorator, FieldKey.Reference, true);
}
export function referenceFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=reference-decorator.js.map