/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { GridNestedFieldTypes } from '../../nested-fields';
import type { NestedExtensionField } from '../../nested-fields-extensions';
import type { NestedOverrideField } from '../../nested-fields-overrides';
import type { BaseReferenceExtensionDecoratorProperties, ReferenceDecoratorProperties } from './reference-types';
export interface ReferenceExtensionDecoratorProperties<T extends ScreenExtension<T>, NodeType extends ClientNode = any> extends BaseReferenceExtensionDecoratorProperties<Extend<T>>, ChangeableOverrideDecoratorProperties<Omit<ReferenceDecoratorProperties<Extend<T>, NodeType>, 'isReferenceDialogOpen'>, Extend<T>> {
    /** The definitions of the nested fields used to represent the table rows */
    columns?: NestedExtensionField<T, GridNestedFieldTypes, NodeType>[];
    /** Allows overriding existing column properties in the base page's columns */
    columnOverrides?: NestedOverrideField<T, GridNestedFieldTypes, NodeType>[];
}
/**
 * Initializes the decorated member as a [Reference]{@link ReferenceControlObject} field with the provided properties
 *
 * @param properties The properties that the [Reference]{@link ReferenceControlObject} field will be initialized with
 */
export declare function referenceField<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: Omit<ReferenceDecoratorProperties<Extend<T>, NodeType>, 'isReferenceDialogOpen'>): (target: T, name: string) => void;
export declare function referenceFieldOverride<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: ReferenceExtensionDecoratorProperties<T, NodeType>): (target: T, name: string) => void;
//# sourceMappingURL=reference-decorator.d.ts.map