/// <reference types="lodash" />
import type { ClientNode } from '@sage/xtrem-client';
import type { UseComboboxStateChangeTypes } from 'downshift';
import * as React from 'react';
import { ContextType } from '../../../types';
import type { CarbonLinkEvent } from '../../../utils/types';
import type { CollectionItem } from '../../types';
import type { PortraitSize } from '../../ui/portrait-component';
import type { SelectItem } from '../../ui/select/select-component';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { ConnectedReferenceComponentProps, ReferenceComponentState, ReferenceDecoratorProperties } from './reference-types';
export declare class ReferenceComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<ReferenceDecoratorProperties<any, T>, T, ConnectedReferenceComponentProps<T>, ReferenceComponentState> {
    private readonly lookupButtonRef;
    private searchText;
    private readonly selectInputRef;
    constructor(props: ConnectedReferenceComponentProps<T>);
    private readonly onInputValueChanged;
    componentDidMount(): void;
    getIsReferenceDialogOpen: () => boolean;
    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
    onMobileButtonClick: (event: React.MouseEvent<HTMLElement>) => void;
    private handleAutoSelection;
    mobileAutoSelect: import("lodash").DebouncedFunc<(type?: UseComboboxStateChangeTypes) => Promise<void>>;
    onButtonClick: (event: CarbonLinkEvent) => void;
    openLookupDialog: () => void;
    closeLookupDialog: (cb?: () => void) => Promise<void>;
    onLookupDialogSelectionFinished: ([selectedRecord]: SelectItem[]) => void;
    hasLookupIcon: () => boolean;
    isLookupDialogOpen: () => boolean;
    isLookupDialogOpenMobile: () => boolean;
    isReadOnlyAndHasPicture: () => boolean;
    render(): React.ReactNode;
    handleOnCreateNewItemLinkClick: () => void;
    renderMobile: (className: string) => React.ReactNode;
    onOpenTunnel: (isNew?: boolean) => Promise<void>;
    getHelperTextLink: () => string | undefined;
    onMobileInputChange: (searchText: string, type?: UseComboboxStateChangeTypes) => Promise<void>;
    onInputChange: (searchText: string, type?: UseComboboxStateChangeTypes) => Promise<void>;
    getPortraitSize: () => PortraitSize;
    getItems: (filterValue: string) => Promise<SelectItem[]>;
    getMinLookupCharacters: () => number;
    renderDesktop: (className: string) => React.ReactNode;
    isRelatedTargetEqualTo: (e: React.FocusEvent<HTMLInputElement>, input: string) => boolean;
}
export declare const ConnectedReferenceComponent: import("react-redux").ConnectedComponent<typeof ReferenceComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ReferenceComponent<ClientNode>> | undefined;
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedReferenceComponent;
//# sourceMappingURL=reference-component.d.ts.map