import React from 'react';
import type { CarbonLinkEvent } from '../../../utils/types';
import type { NestedReferenceProperties } from '../../decorators';
import type { ReferenceCellRendererProps } from './reference-types';
import type { ImageValue } from '../image/image-types';
export declare class ReferenceCellRenderer extends React.Component<ReferenceCellRendererProps> {
    private readonly linkRef;
    componentDidMount(): void;
    shouldComponentUpdate(nextProps: ReferenceCellRendererProps): boolean;
    componentWillUnmount(): void;
    private readonly onFocus;
    /**
     * Searches for the reference field image from the row using the the dot path, first using the bind path of the reference column, then the path of the `imageField`;
     * @returns
     */
    getImageFromProps: () => ImageValue | undefined;
    private getTunnelPageLink;
    private readonly shouldRenderTunnelPageLink;
    private readonly isReadOnly;
    onTunnelLinkClick: (ev: CarbonLinkEvent) => Promise<void>;
    render(): React.ReactNode;
}
export declare const ConnectedReferenceCellRenderer: import("react-redux").ConnectedComponent<typeof ReferenceCellRenderer, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ReferenceCellRenderer> | undefined;
    colDef: Omit<import("../../../utils/ag-grid/ag-grid-utility-types").AgGridColumnConfigWithScreenIdAndColDef, "cellRendererParams"> & Required<Pick<Omit<import("../../../utils/ag-grid/ag-grid-utility-types").AgGridColumnConfigWithScreenIdAndColDef, "cellRendererParams">, "field">> & {
        cellRendererParams: import("../../../utils/ag-grid/ag-grid-column-config").CellProps<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
    };
    value: string;
    node: import("@ag-grid-community/core").RowNode<any>;
    column: import("@ag-grid-community/core").Column<any>;
    data: any;
    context: any;
    fullWidth?: boolean | undefined;
    api: import("@ag-grid-community/core").GridApi<any>;
    getValue?: (() => any) | undefined;
    stopEditing: (suppressNavigateAfterEdit?: boolean | undefined) => void;
    pinned?: "left" | "right" | null | undefined;
    valueFormatted: string | null | undefined;
    eGridCell: HTMLElement;
    eParentOfValue: HTMLElement;
    setValue?: ((value: any) => void) | undefined;
    formatValue?: ((value: any) => string) | undefined;
    refreshCell?: (() => void) | undefined;
    registerRowDragger: (rowDraggerElement: HTMLElement, dragStartPixels?: number | undefined, value?: string | undefined, suppressVisibilityChange?: boolean | undefined) => void;
    setTooltip: (value: string, shouldDisplayTooltip?: (() => boolean) | undefined) => void;
    eventKey: string | null;
    initialValue: any;
    onValueChange: (value: any) => void;
    columnId: string;
    contextNode?: string | number | symbol | undefined;
    elementId: string;
    fieldProperties: import("../../../utils/ag-grid/ag-grid-column-config").WithNestedWrapper<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
    screenId: string;
    tableElementId: string;
    isEditing?: boolean | undefined;
    isParentFieldDisabled: boolean;
    isTableReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean> | undefined;
    isTree: boolean;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedReferenceCellRenderer;
//# sourceMappingURL=reference-cell-renderer.d.ts.map