import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { RadioDecoratorProperties } from './radio-types';
/**
 * Initializes the decorated member as a [Radio]{@link RadioControlObject} field with the provided properties
 *
 * @param properties The properties that the [Radio]{@link RadioControlObject} field will be initialized with
 */
export declare function radioField<T extends ScreenExtension<T>>(properties: RadioDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function radioFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<RadioDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=radio-decorator.d.ts.map