/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { FieldControlObjectResolvedProperty } from '../../property-decorators/control-object-resolved-property-decorator';
import { getValidOptionValuesForSelect } from '../select/select-utils';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
 */
export class RadioControlObject extends EditableFieldControlObject {
    /**
     * The GraphQL node that the select options will be fetched from.
     * When using this property, the node must be an Enum
     */
    get optionType() {
        return this.getUiComponentProperty('optionType');
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
    /** Field's value, only valid options can be set as value. */
    set value(newValue) {
        const validOptions = getValidOptionValuesForSelect(this.options || [], this.optionType);
        if (newValue === null || validOptions.indexOf(newValue) !== -1) {
            this._setValue(newValue);
        }
        else {
            throw new Error(`${newValue} is not a valid option of the ${this.elementId} field. Valid options: ${validOptions.join(', ')}`);
        }
    }
    /** Field's value, only valid options can be set as value. */
    get value() {
        return this._getValue() || null;
    }
}
__decorate([
    FieldControlObjectResolvedProperty()
    /** Options to be displayed in the select element */
], RadioControlObject.prototype, "options", void 0);
//# sourceMappingURL=radio-control-object.js.map