import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { ScreenBase } from '../../../service/screen-base';
import type { ReadonlyFieldProperties } from '../../readonly-field-control-object';
import type { Clickable, ExtensionField, HasParent, Nested, NestedClickable, Sizable, Colorable } from '../traits';
import type { FieldControlObjectInstance } from '../../types';
import type { BlockControlObject } from '../../control-objects';
import type { ClientNode } from '@sage/xtrem-client';
export interface ProgressDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ProgressProperties<CT>, '_controlObjectType'>, Clickable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
}
export interface NestedProgressProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<ProgressProperties<CT>, 'bind'>, Nested<NodeType>, NestedClickable<CT>, Sizable {
}
export interface ProgressProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT>, Colorable<CT> {
    currentProgressLabel?: string;
    maxProgressLabel?: string;
    areProgressLabelsHidden?: boolean;
}
export type ProgressComponentProps = BaseReadonlyComponentProperties<ProgressProperties, number, NestedFieldsAdditionalProperties>;
//# sourceMappingURL=progress-types.d.ts.map