/**
 * @packageDocumentation
 * @module root
 * */
import { xtremConsole } from '../../../utils/console';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ProgressControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ProgressDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = ProgressControlObject;
    }
}
/**
 * Initializes the decorated member as a [Progress]{@link ProgressControlObject} field with the provided properties
 *
 * @param properties The properties that the [Progress]{@link ProgressControlObject} field will be initialized with
 */
export function progressField(properties) {
    return standardDecoratorImplementation(properties, ProgressDecorator, FieldKey.Progress);
}
export function progressFieldOverride(properties) {
    if (properties.color) {
        xtremConsole.warn('Custom colors on progress indicator are now deprecated');
    }
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=progress-decorator.js.map