import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedPluginComponent = React.lazy(() => import('./plugin-component'));
export function AsyncConnectedPluginComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedPluginComponent, { ...props })));
}
const PluginComponent = React.lazy(() => import('./plugin-component').then(c => ({ default: c.PluginComponent })));
export function AsyncPluginComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(PluginComponent, { ...props })));
}
//# sourceMappingURL=async-plugin-component.js.map