import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedNodeBrowserTree = React.lazy(() => import('./node-browser-tree-component'));
export function AsyncConnectedNodeBrowserTreeComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedNodeBrowserTree, { ...props })));
}
const NodeBrowserTreeComponent = React.lazy(() => import('./node-browser-tree-component').then(e => ({ default: e.NodeBrowserTreeComponent })));
export function AsyncNodeBrowserTreeComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(NodeBrowserTreeComponent, { ...props })));
}
//# sourceMappingURL=async-node-browser-tree-component.js.map