import * as React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { runAndDispatchFieldValidation } from '../../../service/dispatch-service';
import { getDataTestIdAttribute, isHidden } from '../../../utils/dom';
import { triggerFieldEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { cleanMetadataFromRecord, splitValueToMergedValue } from '../../../utils/transformers';
import { getFieldTitle, isFieldDisabled } from '../carbon-helpers';
import { HelperText } from '../carbon-utility-components';
import { AsyncDesktopNestedGridComponent } from './async-desktop-nested-grid-component';
import { MobileNestedGridComponent } from './mobile-nested-grid-component';
export class NestedGridComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.getComponentClass = () => {
            const className = ['e-field', 'e-nested-grid-field'];
            if (isHidden(this.props.item, this.props.browser) ||
                resolveByValue({
                    screenId: this.props.screenId,
                    skipHexFormat: true,
                    propertyValue: this.props.fieldProperties.isHidden,
                    rowValue: null,
                })) {
                className.push('e-hidden');
            }
            if (this.props.fieldProperties.isFullWidth) {
                className.push('full-width');
            }
            if (this.props.fieldProperties.isHelperTextHidden) {
                className.push('e-helper-text-hidden');
            }
            if (this.props.fieldProperties.isTitleHidden) {
                className.push('e-title-hidden');
            }
            if (this.props.isParentDisabled ||
                isFieldDisabled(this.props.screenId, this.props.fieldProperties, undefined, undefined)) {
                className.push('e-disabled');
            }
            return className.join(' ');
        };
        this.onRowClick = (recordId, level) => () => {
            if (this.props.value) {
                const rowValue = this.props.value.getRawRecord({ id: recordId, level });
                if (this.props.onRowClick) {
                    this.props.onRowClick(rowValue);
                }
                else {
                    triggerFieldEvent(this.props.screenId, this.props.elementId, 'onRowClick', recordId, cleanMetadataFromRecord(splitValueToMergedValue(rowValue)), level);
                }
            }
        };
    }
    render() {
        const isMobileTable = this.props.fieldProperties.cardView || !this.props.browser.greaterThan.s;
        return (React.createElement("div", { className: this.getComponentClass(), "data-testid": getDataTestIdAttribute('nestedGrid', getFieldTitle(this.props.screenId, this.props.fieldProperties, null), this.props.elementId) },
            !isMobileTable && (React.createElement(AsyncDesktopNestedGridComponent, { accessBindings: this.props.accessBindings, dataTypes: this.props.dataTypes, elementId: this.props.elementId, enumTypes: this.props.enumTypes, fieldProperties: this.props.fieldProperties, isParentDisabled: this.props.isParentDisabled, locale: this.props.locale, nodeTypes: this.props.nodeTypes, onRowClick: this.onRowClick, screenId: this.props.screenId, setFieldProperties: this.props.setFieldProperties, setGlobalLoading: this.props.setGlobalLoading, username: this.props.username, validationErrors: this.props.validationErrors, value: this.props.value })),
            isMobileTable && (React.createElement(MobileNestedGridComponent, { elementId: this.props.elementId, fieldProperties: this.props.fieldProperties, isDisabled: this.props.isParentDisabled || false, value: this.props.value, validationErrors: this.props.validationErrors, screenId: this.props.screenId, openSidebar: this.props.openSidebar, canAddNewLine: false })),
            this.props.fieldProperties.helperText && (React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText }))));
    }
}
const mapStateToProps = (state, props) => {
    const screenDefinition = state.screenDefinitions[props.screenId];
    const fieldProperties = screenDefinition.metadata.uiComponentProperties[props.elementId];
    const pageProperties = screenDefinition.metadata.uiComponentProperties[props.screenId];
    return {
        ...props,
        browser: state.browser,
        dataTypes: state.dataTypes,
        fieldProperties: {
            ...fieldProperties,
            isTransient: pageProperties.isTransient || fieldProperties.isTransient,
        },
        username: state.applicationContext?.login,
        locale: state.applicationContext?.locale || 'base',
        setFieldProperties: xtremRedux.actions.actionStub,
        validate: xtremRedux.actions.actionStub,
        openSidebar: xtremRedux.actions.actionStub,
        value: screenDefinition.values[props.elementId],
        enumTypes: state.enumTypes,
        nodeTypes: state.nodeTypes,
        accessBindings: screenDefinition.accessBindings || {},
        validationErrors: screenDefinition.errors[props.elementId] || [],
        onTelemetryEvent: state.applicationContext?.onTelemetryEvent,
    };
};
const mapDispatchToProps = (dispatch, props) => {
    return {
        validate: (elementId, value) => runAndDispatchFieldValidation(props.screenId, elementId, value.getNormalizedChangedRecords()),
        setFieldProperties: (elementId, value) => {
            dispatch(xtremRedux.actions.setFieldProperties(props.screenId, elementId, value));
        },
        setGlobalLoading: (loaderState) => {
            dispatch(xtremRedux.actions.setGlobalLoading(loaderState));
        },
        openSidebar: ({ screenId, elementId, level, parentId, }) => {
            dispatch(xtremRedux.actions.openTableSidebar({ screenId, elementId, level, parentId }));
        },
    };
};
export const ConnectedNestedGridComponent = connect(mapStateToProps, mapDispatchToProps)(NestedGridComponent);
export default ConnectedNestedGridComponent;
//# sourceMappingURL=nested-grid-component.js.map