import type { ColDef, ColumnState, GridOptions } from '@ag-grid-community/core';
import * as React from 'react';
import type { NestedGridInternalComponentProps } from './nested-grid-component-types';
import type { OptionsMenuItem } from '../../container/page/page-types';
type RowSelectionMode = 'single' | 'multiple' | undefined;
interface NestedGridDesktopState {
    columns: ColDef[];
    detailCellRendererParams: GridOptions['detailCellRendererParams'];
    isExportingExcel: boolean;
    rowSelectionMode: RowSelectionMode;
    selectedOptionsMenuItem?: OptionsMenuItem;
    isConfigurationDialogOpen?: boolean;
    columnStates?: ColumnState[];
    tableHasData?: boolean;
}
export declare class DesktopNestedGridComponent extends React.Component<NestedGridInternalComponentProps, NestedGridDesktopState> {
    private gridApi;
    private dataOperationMode;
    private collectionValueChangeSubscription;
    private actionSubscription;
    private readonly containerRef;
    private readonly collectionValidityChangeSubscriptions;
    constructor(props: NestedGridInternalComponentProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: NestedGridInternalComponentProps): void;
    componentWillUnmount(): void;
    private getGridApiByRecordPath;
    private readonly setShouldResetTable;
    /**
     * Child tables are destroyed by ag-grid upon paginating
     * so we can just collapse them and let the user expand them again
     */
    private readonly onPaginationChanged;
    private readonly onOptionsMenuItemChange;
    private readonly getRowClass;
    private readonly isDisabled;
    private readonly isReadOnly;
    private readonly noRowsOverlayComponentParams;
    private readonly onCellKeyDown;
    private readonly onCellClicked;
    private readonly getRowNode;
    private readonly getCommonGridProps;
    private readonly onRowGroupOpened;
    private readonly onFilterChanged;
    private readonly onSortChanged;
    private readonly focusPhantomRowAndStartEditing;
    private readonly onCollectionUpdated;
    private readonly getCurrentlySelectedRecords;
    private readonly isRecordSelected;
    /** Marks items selected on the nestedGrid, this function is triggered by changes initiated by a pagination or reset
     * event
     **/
    private readonly selectNestedGridItems;
    private readonly getParentNode;
    private readonly unselectParentsRecursive;
    private readonly selectParentsRecursive;
    private readonly insertDataSourceIntoNestedGrid;
    private getCursor;
    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
     * event
     **/
    private readonly selectTableItems;
    private readonly onCellEditingStopped;
    private readonly onValidityChange;
    private readonly subscribeToValidationChanges;
    private readonly setPhantomRow;
    private readonly getRowCount;
    /**
     * Ag-grid callback which is triggered whenever the nestedGrid component needs new data from our framework
     * @param getRowsParams
     */
    private readonly getRows;
    private readonly serverSideDataSource;
    /**
     * Ag-grid lifecycle event listener. It is triggered when the nestedGrid is prepared with the initial rendering of the
     * controller components and is ready to receive data.
     **/
    private readonly onGridReady;
    /** Event listener, triggered when the user clicks on any part of the row apart from the dropdown actions */
    private readonly onRowClick;
    /**
     * Gets the IDs of all rows that have been selected.
     *
     * @private
     * @memberof DesktopNestedGridComponent
     */
    private readonly getSelectedNodes;
    private readonly getPreviouslySelectedItemIds;
    /**
     * Gets the IDs of all the rows that have been unselected.
     *
     * @private
     * @memberof DesktopNestedGridComponent
     */
    private readonly getUnselectedIds;
    private readonly selectRow;
    private readonly unselectRow;
    private readonly getNewlySelectedRowIds;
    private readonly selectUnselectAllChildren;
    /**
     * Event listener, triggered when the user clicks the checkbox on the front of the row. Both for selection and
     * deselection.
     * */
    private readonly onSelectionChange;
    private readonly getRowId;
    /**
     * This function gets called whenever a row gets expanded.
     * This is where the sever-side data source is set.
     * Information about the grid's level as well as its parent ID & parent grid api is added to ag-grid's context
     * and is used for filtering, sorting and selection.
     *
     * @private
     * @param {GetDetailRowDataParams} { successCallback, ...params }
     * @memberof DesktopNestedGridComponent
     */
    private readonly getDetailRowData;
    private readonly getDetailCellRendererParams;
    private readonly getCollectionValue;
    private readonly getMainMenuItems;
    private readonly getAllColumnIds;
    updateColumnState(): void;
    private readonly onColumnPanelHiddenStateChange;
    private readonly onColumnPanelOrderChangeChange;
    private readonly autoSizeAllColumns;
    private readonly onFirstDataRendered;
    private readonly resetOptionsMenu;
    private readonly getColumnDefinitions;
    private readonly getCacheBlockSize;
    private readonly getRowSelectionMode;
    private readonly loadingCellRendererParams;
    private readonly onFocusPhantomRow;
    render(): React.ReactNode;
}
export default DesktopNestedGridComponent;
//# sourceMappingURL=desktop-nested-grid-component.d.ts.map