import { addColumnsToProperties, addDisabledToProperties, addHelperTextFieldToProperties, addNodeToProperties, addValueFieldToProperties, } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { MultiReferenceControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
export var MultiReferenceDecoratorPropertiesKeys;
(function (MultiReferenceDecoratorPropertiesKeys) {
    MultiReferenceDecoratorPropertiesKeys["isDropdownDisabled"] = "isDropdownDisabled";
    MultiReferenceDecoratorPropertiesKeys["onOpenMultiReferenceDialog"] = "onOpenMultiReferenceDialog";
    MultiReferenceDecoratorPropertiesKeys["onCloseMultiReferenceDialog"] = "onCloseMultiReferenceDialog";
    MultiReferenceDecoratorPropertiesKeys["minLookupCharacters"] = "minLookupCharacters";
})(MultiReferenceDecoratorPropertiesKeys || (MultiReferenceDecoratorPropertiesKeys = {}));
class MultiReferenceDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = MultiReferenceControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addNodeToProperties({ dataType, propertyDetails, properties });
        addColumnsToProperties({
            dataType,
            propertyDetails,
            properties,
            dataTypes: this.dataTypes,
            nodeTypes: this.nodeTypes,
        }, true);
        addValueFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addHelperTextFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [MultiReference]{@link MultiReferenceControlObject} field with the provided properties
 *
 * @param properties The properties that the [MultiReference]{@link MultiReferenceControlObject} field will be initialized with
 */
export function multiReferenceField(properties) {
    return standardDecoratorImplementation(properties, MultiReferenceDecorator, FieldKey.MultiReference, true);
}
export function multiReferenceFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=multi-reference-decorator.js.map