/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { NestedFieldTypes } from '../../nested-fields';
import type { NestedExtensionField } from '../../nested-fields-extensions';
import type { NestedOverrideField } from '../../nested-fields-overrides';
import type { MultiReferenceDecoratorProperties } from './multi-reference-types';
export declare enum MultiReferenceDecoratorPropertiesKeys {
    isDropdownDisabled = "isDropdownDisabled",
    onOpenMultiReferenceDialog = "onOpenMultiReferenceDialog",
    onCloseMultiReferenceDialog = "onCloseMultiReferenceDialog",
    minLookupCharacters = "minLookupCharacters"
}
type BaseMultiReferenceExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase> = {
    onCloseMultiReferenceDialogAfter?: (this: CT, _id: any) => void;
    onOpenMultiReferenceDialogAfter?: (this: CT, _id: any) => void;
};
export interface MultiReferenceExtensionDecoratorProperties<T extends ScreenExtension<T>, NodeType extends ClientNode = any> extends BaseMultiReferenceExtensionDecoratorProperties<Extend<T>>, ChangeableOverrideDecoratorProperties<Omit<MultiReferenceDecoratorProperties<Extend<T>, NodeType>, 'isMultiReferenceDialogOpen'>, Extend<T>> {
    /** The definitions of the nested fields used to represent the table rows */
    columns?: NestedExtensionField<T, NestedFieldTypes, NodeType>[];
    /** Allows overriding existing column properties in the base page's columns */
    columnOverrides?: NestedOverrideField<T, NestedFieldTypes, NodeType>[];
}
/**
 * Initializes the decorated member as a [MultiReference]{@link MultiReferenceControlObject} field with the provided properties
 *
 * @param properties The properties that the [MultiReference]{@link MultiReferenceControlObject} field will be initialized with
 */
export declare function multiReferenceField<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: Omit<MultiReferenceDecoratorProperties<Extend<T>, NodeType>, 'isMultiReferenceDialogOpen'>): (target: T, name: string) => void;
export declare function multiReferenceFieldOverride<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: MultiReferenceExtensionDecoratorProperties<T, NodeType>): (target: T, name: string) => void;
export {};
//# sourceMappingURL=multi-reference-decorator.d.ts.map