import type { ClientNode } from '@sage/xtrem-client';
import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { MultiReferenceComponentProps, MultiReferenceComponentState, MultiReferenceDecoratorProperties } from './multi-reference-types';
export declare class MultiReferenceComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<MultiReferenceDecoratorProperties<any, T>, T[], NestedFieldsAdditionalProperties, MultiReferenceComponentState> {
    private readonly lookupButtonRef;
    private readonly selectInputRef;
    constructor(props: MultiReferenceComponentProps<T>);
    private readonly onInputValueChanged;
    private readonly onMobileInputChange;
    componentDidMount(): void;
    componentDidUpdate(prevProps: MultiReferenceComponentProps<T>): void;
    private readonly onSelectedItemsChange;
    private readonly openLookupDialog;
    private readonly closeLookupDialog;
    private readonly onLookupDialogSelectionFinished;
    private readonly hasLookupIcon;
    private readonly getBorderColor;
    private readonly isLookupDialogOpen;
    private readonly isLookupDialogOpenMobile;
    private readonly isReadOnlyAndHasPicture;
    private readonly mobileAutoSelect;
    render(): React.ReactNode;
    private readonly renderMobile;
    private readonly getItems;
    private readonly getMinLookupCharacters;
    private readonly renderDesktop;
    isRelatedTargetEqualTo: (e: React.FocusEvent<HTMLInputElement>, input: string) => boolean;
}
export declare const ConnectedMultiReferenceComponent: import("react-redux").ConnectedComponent<typeof MultiReferenceComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<MultiReferenceComponent<ClientNode>> | undefined;
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedMultiReferenceComponent;
//# sourceMappingURL=multi-reference-component.d.ts.map