import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentProperties, MultiFileDepositDecoratorProperties, WithCancelToken } from './multi-file-deposit-types';
import type { AttachmentAssociation } from '../../types';
import { ContextType } from '../../../types';
import type { CollectionValue } from '../../../service/collection-data-service';
interface MultiFileDepositComponentState {
    hasValue: boolean;
    isFileInputVisible: boolean;
}
export declare class MultiFileDepositComponent extends EditableFieldBaseComponent<MultiFileDepositDecoratorProperties<any>, CollectionValue<WithCancelToken<AttachmentAssociation>>, MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentState> {
    private changeSubscription;
    constructor(props: MultiFileDepositComponentProperties);
    componentDidMount(): void;
    componentWillUnmount(): void;
    onChange: (fileList: FileList) => void;
    cancelFileUploading: (recordId: string) => void;
    displayCancelUploadDialog(recordId: string): Promise<void>;
    displayRemoveFileDialog(recordId: string): Promise<void>;
    toggleDropzone: () => void;
    renderUploadedFilesTable: () => React.ReactElement | null;
    render(): React.ReactElement;
}
export declare const ConnectedMultiFileDepositComponent: import("react-redux").ConnectedComponent<typeof MultiFileDepositComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<MultiFileDepositComponent> | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedMultiFileDepositComponent;
//# sourceMappingURL=multi-file-deposit-component.d.ts.map