import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedMultiFileDepositComponent = React.lazy(() => import('./multi-file-deposit-component'));
export function AsyncConnectedMultiFileDepositComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedMultiFileDepositComponent, { ...props })));
}
const MultiFileDepositComponent = React.lazy(() => import('./multi-file-deposit-component').then(c => ({ default: c.MultiFileDepositComponent })));
export function AsyncMultiFileDepositComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(MultiFileDepositComponent, { ...props })));
}
//# sourceMappingURL=async-multi-file-deposit-component.js.map