/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import { LabelDecoratorProperties, NestedLabelProperties } from './label-types';
/**
 * Initializes the decorated member as a [Label]{@link LabelControlObject} field with the provided properties
 *
 * @param properties The properties that the [Label]{@link LabelControlObject} field will be initialized with
 */
export declare function labelField<T extends ScreenExtension<T>>(properties: LabelDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function labelFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<LabelDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
export { LabelDecoratorProperties, NestedLabelProperties };
//# sourceMappingURL=label-decorator.d.ts.map