/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { IconControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class IconDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = IconControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Icon]{@link IconControlObject} field with the provided properties
 *
 * @param properties The properties that the [Icon]{@link IconControlObject} field will be initialized with
 */
export function iconField(properties) {
    return standardDecoratorImplementation(properties, IconDecorator, FieldKey.Icon);
}
export function iconFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=icon-decorator.js.map