import * as React from 'react';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../../utils/transformers';
import { Icon } from '../../ui/icon/icon-component';
export const IconCellRenderer = React.memo(props => {
    const { fieldProperties, data: rowValue } = props;
    if (rowValue && props.value) {
        const screenId = props.colDef.screenId;
        const originalValue = props.data[props.colDef.field];
        const mappedValue = props.value;
        const isHidden = resolveByValue({
            fieldValue: originalValue,
            propertyValue: fieldProperties.isHidden,
            skipHexFormat: true,
            screenId,
            rowValue: splitValueToMergedValue(rowValue),
        });
        if (isHidden) {
            return null;
        }
        return (React.createElement(fieldProperties.wrapper, { ...props },
            React.createElement(Icon, { className: `e-field-value${fieldProperties.onClick ? ' e-icon-clickable' : ''}`, 
                // TODO: Type "color" and "backgroundColor" based on the field type
                // The Carbon library only supports some values here, the functional developer has to be aware
                bg: resolveByValue({
                    fieldValue: originalValue,
                    propertyValue: fieldProperties.backgroundColor,
                    screenId,
                    rowValue: splitValueToMergedValue(rowValue),
                }), color: resolveByValue({
                    fieldValue: originalValue,
                    propertyValue: fieldProperties.color,
                    screenId,
                    rowValue: splitValueToMergedValue(rowValue),
                }), bgShape: resolveByValue({
                    fieldValue: originalValue,
                    propertyValue: fieldProperties.backgroundShape,
                    screenId,
                    rowValue: splitValueToMergedValue(rowValue),
                }), type: mappedValue })));
    }
    return null;
});
IconCellRenderer.displayName = 'IconCellRenderer';
//# sourceMappingURL=icon-cell-renderer.js.map