import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { BinaryValue } from '../../types';
import type { FormDesignerComponentProps, FormDesignerDecoratorProperties } from './form-designer-types';
export interface FormDesignerComponentState {
    value: string;
    headerValue: string;
    footerValue: string;
    isDirty: boolean;
}
export declare class FormDesignerComponent extends EditableFieldBaseComponent<FormDesignerDecoratorProperties, BinaryValue, NestedFieldsAdditionalProperties, FormDesignerComponentState> {
    private actionSubscription;
    constructor(props: FormDesignerComponentProps);
    componentWillReceiveProps(nextProps: Readonly<FormDesignerComponentProps>): void;
    componentWillUnmount(): void;
    private readonly onReadyEvent;
    private readonly onChange;
    private readonly onHeaderChange;
    private readonly onFooterChange;
    private readonly getObjectDetails;
    private readonly onEditorReady;
    private readonly onObjectInsert;
    private readonly getDocumentParameters;
    private readonly onDisplayToast;
    private readonly contextProvider;
    render(): React.ReactNode;
}
export declare const ConnectedFormDesignerComponent: import("react-redux").ConnectedComponent<typeof FormDesignerComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<FormDesignerComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedFormDesignerComponent;
//# sourceMappingURL=form-designer-component.d.ts.map